# Backend (API + Admin) — Installation Namecheap (simple)

## A. Créer la base MySQL (cPanel)
1. Connectez-vous à votre **cPanel** Namecheap
2. Allez dans **Databases > Manage My Databases**
3. Créez :
   - une base de données
   - un utilisateur
   - associez l'utilisateur à la base avec **ALL PRIVILEGES**
4. Ouvrez **phpMyAdmin** et importez : `sql/schema.sql`

## B. Uploader les fichiers
Sur votre hébergement (dossier `public_html/`), uploadez :
- `api/` (dossier)
- `admin/` (dossier)

Vous devez obtenir :
- `https://votredomaine.com/api/health`
- `https://votredomaine.com/admin/login.php`

## C. Configurer l'API
Éditez le fichier :
- `api/config.php`

Remplacez :
- `VOTRE_DB_NAME`
- `VOTRE_DB_USER`
- `VOTRE_DB_PASSWORD`
- Et changez `token_secret`

## D. Créer le premier admin
Ouvrez :
- `https://votredomaine.com/admin/setup.php`

Créez l'admin, puis **supprimez** `setup.php` (important sécurité).

## E. Ajouter des questions
Allez sur :
- `https://votredomaine.com/admin/questions.php`

Créez au moins quelques questions par :
- classe
- filière

## F. Tester l'API
- `GET https://votredomaine.com/api/health` -> `{"ok":true...}`

L'app Android utilise :
- `GET /api/classes` (liste des classes)
- `GET /api/subjects` (liste des filières)
- `GET /api/settings` (timer et points)
- `POST /api/register` (avec `classId`)
- `POST /api/login`
- `GET /api/me`
- `GET /api/questions?subjectId=...&limit=10` (classe déduite de l'utilisateur)
- `POST /api/answer`
- `GET /api/leaderboard?limit=50`

## G. Diaporama (3 images sur l'accueil)
1. Assurez-vous d'avoir aussi le dossier `uploads/` à la racine du site :
   - `public_html/uploads/carousel/`
2. Dans l'Admin :
   - `https://votredomaine.com/admin/carousel.php`
3. L'API utilisée par l'app :
   - `GET /api/carousel` (renvoie les 3 images actives)

## H. Changer de classe depuis l'app
- L'app appelle :
  - `POST /api/update_class` avec `{ "classId": 3 }` (token requis)
