<?php
require_once __DIR__ . "/includes/admin_auth.php";
require_once __DIR__ . "/includes/meta.php";

$adminUser = require_admin();
$pdo = db();

$msg = null;
$err = null;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  // Si l'utilisateur clique sur "Supprimer" ou "Activer/Désactiver" dans le formulaire d'ordre,
  // on force l'action correspondante.
  $deleteId = (int)($_POST["delete_id"] ?? 0);
  $toggleId = (int)($_POST["toggle_id"] ?? 0);
  $action = $deleteId > 0 ? "delete" : ($toggleId > 0 ? "toggle_active" : ($_POST["action"] ?? "add"));

  if ($action === "add") {
    $name = trim($_POST["name"] ?? "");
    if ($name === "") {
      $err = "Nom de classe requis.";
    } else {
      try {
        // Nouvelle classe: placée à la fin par défaut
        $max = (int)($pdo->query("SELECT COALESCE(MAX(sort_order),0) AS m FROM classes")->fetch()["m"] ?? 0);
        $stmt = $pdo->prepare("INSERT INTO classes (name, sort_order) VALUES (?, ?)");
        $stmt->execute([$name, $max + 1]);
        $msg = "Classe ajoutée.";
      } catch (Throwable $e) {
        $err = "Impossible d'ajouter cette classe (déjà existante ?)";
      }
    }
  } else if ($action === "toggle_active") {
    $id = $toggleId;
    try {
      $stmt = $pdo->prepare("UPDATE classes SET is_active = IF(is_active=1,0,1) WHERE id=?");
      $stmt->execute([$id]);
      $msg = "Statut de la classe mis à jour.";
    } catch (Throwable $e) {
      $err = "Impossible de modifier le statut.";
    }
  } else if ($action === "delete") {
    $id = $deleteId > 0 ? $deleteId : (int)($_POST["id"] ?? 0);
    if ($id > 0) {
      try {
        $stmt = $pdo->prepare("DELETE FROM classes WHERE id = ?");
        $stmt->execute([$id]);
        $msg = "Classe supprimée.";
      } catch (Throwable $e) {
        $err = "Impossible de supprimer: cette classe est utilisée par des utilisateurs/questions.";
      }
    }
  } else if ($action === "save_order") {
    // Sauvegarde de l'ordre (rang) des classes
    $orderMap = $_POST["order"] ?? [];
    if (!is_array($orderMap)) $orderMap = [];

    try {
      $pdo->beginTransaction();
      $stmt = $pdo->prepare("UPDATE classes SET sort_order = ? WHERE id = ?");
      foreach ($orderMap as $idStr => $ordStr) {
        $id = (int)$idStr;
        if ($id <= 0) continue;
        $ord = (int)$ordStr;
        // bornes raisonnables
        if ($ord < 1) $ord = 1;
        if ($ord > 9999) $ord = 9999;
        $stmt->execute([$ord, $id]);
      }
      $pdo->commit();
      $msg = "Ordre des classes mis à jour.";
    } catch (Throwable $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $err = "Impossible de sauvegarder l'ordre.";
    }
  }
}

$classes = get_classes($pdo);

$pageTitle = "Classes";
require __DIR__ . "/includes/header.php";
?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card p-4">
      <h5 class="mb-3">Ajouter une classe</h5>
      <?php if ($msg): ?><div class="alert alert-success"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
      <?php if ($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>
      <form method="post" class="d-flex gap-2">
        <input type="hidden" name="action" value="add">
        <input class="form-control" name="name" placeholder="ex: 2nde C" required>
        <button class="btn btn-primary">Ajouter</button>
      </form>
      <div class="small-muted mt-2">Conseil: gardez des noms courts (ex: CM2, 6ème, Terminale...).</div>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card p-4">
      <h5 class="mb-3">Liste des classes</h5>
      <div class="small-muted mb-2">Définis l'ordre d'affichage dans l'application (1 = premier). Puis clique sur <b>Enregistrer l'ordre</b>.</div>
      <div class="table-responsive">
        <form method="post">
          <input type="hidden" name="action" value="save_order">
          <table class="table table-hover align-middle">
            <thead>
              <tr>
                <th style="width:90px">Ordre</th>
                <th>ID</th><th>Nom</th><th>Statut</th>
                <th class="text-end" style="width:200px">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($classes as $c): ?>
                <tr>
                  <td>
                    <input
                      class="form-control form-control-sm"
                      type="number"
                      min="1"
                      max="9999"
                      name="order[<?= (int)$c["id"] ?>]"
                      value="<?= (int)($c["sort_order"] ?? 0) ?>"
                    />
                  </td>
                  <td><?= (int)$c["id"] ?></td>
                  <td><span class="badge badge-soft"><?= htmlspecialchars($c["name"]) ?></span></td>
                  <td>
                    <?php if ((int)($c["is_active"] ?? 1) === 1): ?>
                      <span class="badge text-bg-success">Active</span>
                    <?php else: ?>
                      <span class="badge text-bg-secondary">Désactivée</span>
                    <?php endif; ?>
                  </td>
                  <td class="text-end">
                    <button
                      class="btn btn-sm btn-outline-secondary me-2"
                      type="submit"
                      name="toggle_id"
                      value="<?= (int)$c["id"] ?>"
                    ><?php if ((int)($c["is_active"] ?? 1) === 1): ?>Désactiver<?php else: ?>Activer<?php endif; ?></button>
                    <button
                      class="btn btn-sm btn-outline-danger"
                      type="submit"
                      name="delete_id"
                      value="<?= (int)$c["id"] ?>"
                      onclick="return confirm('Supprimer cette classe ?');"
                    >Supprimer</button>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
          <div class="d-flex justify-content-end">
            <button class="btn btn-primary">Enregistrer l'ordre</button>
          </div>
        </form>
      </div>
      <div class="small-muted mt-2">Si une classe est utilisée, il faut d'abord supprimer les questions liées (ou changer la classe des utilisateurs).</div>
    </div>
  </div>
</div>

<?php require __DIR__ . "/includes/footer.php"; ?>
