<?php
require_once __DIR__ . "/includes/admin_auth.php";
$adminUser = require_admin();

$pdo = db();
$userCount = (int)$pdo->query("SELECT COUNT(*) AS c FROM users WHERE role='student'")->fetch()["c"];
$qCount = (int)$pdo->query("SELECT COUNT(*) AS c FROM questions")->fetch()["c"];

$top = $pdo->query(
    "SELECT u.display_name,u.email,c.name AS class_name,u.points
     FROM users u JOIN classes c ON c.id=u.class_id
     WHERE u.role='student'
     ORDER BY u.points DESC, u.id ASC LIMIT 10"
)->fetchAll();

$pageTitle = "Dashboard";
require __DIR__ . "/includes/header.php";
?>

<div class="row g-3">
  <div class="col-md-6">
    <div class="card p-4">
      <div class="small-muted">Utilisateurs (étudiants)</div>
      <div class="display-6"><?= $userCount ?></div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card p-4">
      <div class="small-muted">Questions</div>
      <div class="display-6"><?= $qCount ?></div>
    </div>
  </div>
</div>

<div class="card p-4 mt-3">
  <h5 class="mb-3">Top utilisateurs</h5>
  <div class="table-responsive">
    <table class="table table-hover align-middle">
      <thead>
        <tr>
          <th>#</th><th>Nom</th><th>Email</th><th>Classe</th><th class="text-end">Points</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($top as $i => $u): ?>
        <tr>
          <td><?= $i+1 ?></td>
          <td><?= htmlspecialchars($u["display_name"]) ?></td>
          <td><?= htmlspecialchars($u["email"]) ?></td>
          <td><span class="badge badge-soft"><?= htmlspecialchars($u["class_name"]) ?></span></td>
          <td class="text-end fw-semibold"><?= (int)$u["points"] ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require __DIR__ . "/includes/footer.php"; ?>
