<?php
session_start();
require_once __DIR__ . "/../../api/db.php";

function require_admin(): array {
    if (!isset($_SESSION["admin_id"])) {
        header("Location: login.php");
        exit;
    }
    $pdo = db();
    $stmt = $pdo->prepare("SELECT id,email,display_name,role FROM users WHERE id = ? LIMIT 1");
    $stmt->execute([$_SESSION["admin_id"]]);
    $u = $stmt->fetch();
    if (!$u || $u["role"] !== "admin") {
        session_destroy();
        header("Location: login.php");
        exit;
    }
    return $u;
}
