<?php
require_once __DIR__ . "/../../api/db.php";
require_once __DIR__ . "/../../api/helpers.php";

function get_classes(PDO $pdo, bool $onlyActive = false): array {
  // Tri admin/app: d'abord l'ordre choisi (sort_order), puis le nom.
  // Les classes désactivées restent visibles dans l'admin.
  if ($onlyActive) {
    $rows = $pdo->query("SELECT id,name,sort_order,is_active FROM classes WHERE is_active=1 ORDER BY sort_order ASC, name ASC")->fetchAll();
  } else {
    $rows = $pdo->query("SELECT id,name,sort_order,is_active FROM classes ORDER BY is_active DESC, sort_order ASC, name ASC")->fetchAll();
  }
  $out = [];
  foreach ($rows as $r) {
    $out[] = [
      "id" => (int)$r["id"],
      "name" => $r["name"],
      "sort_order" => (int)($r["sort_order"] ?? 0),
      "is_active" => (int)($r["is_active"] ?? 1),
    ];
  }
  return $out;
}

function get_subjects(PDO $pdo, bool $onlyActive = false): array {
  // Tri admin/app: d'abord l'ordre choisi (sort_order), puis le nom.
  if ($onlyActive) {
    $rows = $pdo->query("SELECT id,name,sort_order,is_active FROM subjects WHERE is_active=1 ORDER BY sort_order ASC, name ASC")->fetchAll();
  } else {
    $rows = $pdo->query("SELECT id,name,sort_order,is_active FROM subjects ORDER BY is_active DESC, sort_order ASC, name ASC")->fetchAll();
  }
  $out = [];
  foreach ($rows as $r) {
    $out[] = [
      "id" => (int)$r["id"],
      "name" => $r["name"],
      "sort_order" => (int)($r["sort_order"] ?? 0),
      "is_active" => (int)($r["is_active"] ?? 1),
    ];
  }
  return $out;
}

function upsert_setting(PDO $pdo, string $k, string $v): void {
  $stmt = $pdo->prepare("INSERT INTO settings (k, v) VALUES (?, ?) ON DUPLICATE KEY UPDATE v = VALUES(v)");
  $stmt->execute([$k, $v]);
}
