<?php
session_start();
require_once __DIR__ . "/../api/db.php";

$error = null;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = strtolower(trim($_POST["email"] ?? ""));
    $pass = (string)($_POST["password"] ?? "");

    $pdo = db();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND role='admin' LIMIT 1");
    $stmt->execute([$email]);
    $u = $stmt->fetch();

    if (!$u || !password_verify($pass, $u["password_hash"])) {
        $error = "Identifiants incorrects.";
    } else {
        $_SESSION["admin_id"] = $u["id"];
        header("Location: dashboard.php");
        exit;
    }
}

?>
<!doctype html>
<html lang="fr" data-bs-theme="dark">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Connexion Admin - Quiz CM</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <script>
    // Appliquer le thème dès que possible (avant le rendu)
    (function(){
      try{
        var t = localStorage.getItem('quizcm_admin_theme');
        if(t==='light' || t==='dark') document.documentElement.setAttribute('data-bs-theme', t);
      }catch(e){}
    })();
  </script>
</head>
<body>
<div class="container py-5" style="max-width: 560px;">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h1 class="mb-1">Admin • Quiz CM</h1>
      <p class="small-muted mb-0">Connexion au panneau d'administration.</p>
    </div>
    <button id="themeToggle" class="btn btn-outline-secondary btn-sm" type="button" title="Mode sombre / clair">🌓</button>
  </div>

  <?php if ($error): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>

  <form method="post" class="card p-4">
    <div class="mb-3">
      <label class="form-label">Email</label>
      <input class="form-control" type="email" name="email" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Mot de passe</label>
      <input class="form-control" type="password" name="password" required>
    </div>
    <button class="btn btn-primary">Se connecter</button>
  </form>

  <div class="mt-3 small-muted">
    Si c'est la première fois: ouvrez <code>/admin/setup.php</code>.
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/admin.js"></script>
</body>
</html>
