<?php
require_once __DIR__ . "/includes/admin_auth.php";
require_once __DIR__ . "/includes/meta.php";

$adminUser = require_admin();
$pdo = db();

$msg = null;
$err = null;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  // Si l'utilisateur clique sur "Supprimer" dans le formulaire d'ordre,
  // on force l'action à delete.
  $deleteId = (int)($_POST["delete_id"] ?? 0);
  $toggleId = (int)($_POST["toggle_id"] ?? 0);
  $action = $deleteId > 0 ? "delete" : ($toggleId > 0 ? "toggle_active" : ($_POST["action"] ?? "add"));
  if ($action === "add") {
    $name = trim($_POST["name"] ?? "");
    if ($name === "") {
      $err = "Nom de filière requis.";
    } else {
      try {
        // Nouvelle filière: placée à la fin par défaut
        $max = (int)($pdo->query("SELECT COALESCE(MAX(sort_order),0) AS m FROM subjects")->fetch()["m"] ?? 0);
        $stmt = $pdo->prepare("INSERT INTO subjects (name, sort_order) VALUES (?, ?)");
        $stmt->execute([$name, $max + 1]);
        $msg = "Filière ajoutée.";
      } catch (Throwable $e) {
        $err = "Impossible d'ajouter cette filière (déjà existante ?)";
      }
    }
  } else if ($action === "toggle_active") {
    $id = $toggleId;
    try {
      $stmt = $pdo->prepare("UPDATE subjects SET is_active = IF(is_active=1,0,1) WHERE id=?");
      $stmt->execute([$id]);
      $msg = "Statut de la filière mis à jour.";
    } catch (Throwable $e) {
      $err = "Impossible de modifier le statut.";
    }
  } else if ($action === "delete") {
    $id = $deleteId > 0 ? $deleteId : (int)($_POST["id"] ?? 0);
    if ($id > 0) {
      try {
        $stmt = $pdo->prepare("DELETE FROM subjects WHERE id = ?");
        $stmt->execute([$id]);
        $msg = "Filière supprimée.";
      } catch (Throwable $e) {
        $err = "Impossible de supprimer: cette filière est utilisée par des questions.";
      }
    }
  } else if ($action === "save_order") {
    // Sauvegarde de l'ordre (rang) des filières
    $orderMap = $_POST["order"] ?? [];
    if (!is_array($orderMap)) $orderMap = [];

    try {
      $pdo->beginTransaction();
      $stmt = $pdo->prepare("UPDATE subjects SET sort_order = ? WHERE id = ?");
      foreach ($orderMap as $idStr => $ordStr) {
        $id = (int)$idStr;
        if ($id <= 0) continue;
        $ord = (int)$ordStr;
        // bornes raisonnables
        if ($ord < 1) $ord = 1;
        if ($ord > 9999) $ord = 9999;
        $stmt->execute([$ord, $id]);
      }
      $pdo->commit();
      $msg = "Ordre des filières mis à jour.";
    } catch (Throwable $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $err = "Impossible de sauvegarder l'ordre.";
    }
  }
}

$subjects = get_subjects($pdo);

$pageTitle = "Filières";
require __DIR__ . "/includes/header.php";
?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card p-4">
      <h5 class="mb-3">Ajouter une filière</h5>
      <?php if ($msg): ?><div class="alert alert-success"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
      <?php if ($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>
      <form method="post" class="d-flex gap-2">
        <input type="hidden" name="action" value="add">
        <input class="form-control" name="name" placeholder="ex: Mathématiques" required>
        <button class="btn btn-primary">Ajouter</button>
      </form>
      <div class="small-muted mt-2">Les filières correspondent aux catégories visibles dans l'application.</div>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card p-4">
      <h5 class="mb-3">Liste des filières</h5>
      <div class="small-muted mb-2">Définis l'ordre d'affichage dans l'application (1 = premier). Puis clique sur <b>Enregistrer l'ordre</b>.</div>
      <div class="table-responsive">
        <form method="post">
          <input type="hidden" name="action" value="save_order">
          <table class="table table-hover align-middle">
            <thead>
              <tr>
                <th style="width:90px">Ordre</th>
                <th>ID</th><th>Nom</th><th>Statut</th>
                <th class="text-end" style="width:160px">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($subjects as $s): ?>
                <tr>
                  <td>
                    <input
                      class="form-control form-control-sm"
                      type="number"
                      min="1"
                      max="9999"
                      name="order[<?= (int)$s["id"] ?>]"
                      value="<?= (int)($s["sort_order"] ?? 0) ?>"
                    />
                  </td>
                  <td><?= (int)$s["id"] ?></td>
                  <td><?= htmlspecialchars($s["name"]) ?></td>
                  <td>
                    <?php if ((int)($s["is_active"] ?? 1) === 1): ?>
                      <span class="badge text-bg-success">Active</span>
                    <?php else: ?>
                      <span class="badge text-bg-secondary">Désactivée</span>
                    <?php endif; ?>
                  </td>
                  <td class="text-end">
                    <button
                      class="btn btn-sm btn-outline-secondary me-2"
                      type="submit"
                      name="toggle_id"
                      value="<?= (int)$s["id"] ?>"
                    ><?php if ((int)($s["is_active"] ?? 1) === 1): ?>Désactiver<?php else: ?>Activer<?php endif; ?></button>
                    <button
                      class="btn btn-sm btn-outline-danger"
                      type="submit"
                      name="delete_id"
                      value="<?= (int)$s["id"] ?>"
                      onclick="return confirm('Supprimer cette filière ?');"
                    >Supprimer</button>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>

          <div class="d-flex justify-content-end">
            <button class="btn btn-primary">Enregistrer l'ordre</button>
          </div>
        </form>
      </div>
      <div class="small-muted mt-2">Si une filière est utilisée, supprimez d'abord les questions liées.</div>
    </div>
  </div>
</div>

<?php require __DIR__ . "/includes/footer.php"; ?>
