<?php
require_once __DIR__ . "/db.php";
require_once __DIR__ . "/helpers.php";

function bearer_token(): ?string {
    $hdr = $_SERVER["HTTP_AUTHORIZATION"] ?? "";
    if (stripos($hdr, "Bearer ") === 0) {
        return trim(substr($hdr, 7));
    }
    return null;
}

function require_user(): array {
    $token = bearer_token();
    if (!$token) json_response(["error" => "Token manquant"], 401);

    $pdo = db();
    $stmt = $pdo->prepare(
        "SELECT u.id,u.email,u.phone,u.display_name,u.class_id,c.name AS class_name,c.is_active AS class_active,u.points,u.role,u.is_blocked,u.token
         FROM users u
         JOIN classes c ON c.id = u.class_id
         WHERE u.token = ?
         LIMIT 1"
    );
    $stmt->execute([$token]);
    $u = $stmt->fetch();
    if (!$u) json_response(["error" => "Token invalide"], 401);

    // User can be blocked by admin
    if (isset($u['is_blocked']) && (int)$u['is_blocked'] === 1) {
        json_response(["error" => "Compte bloqué. Contactez l'administrateur."], 403);
    }

    // Class can be disabled by admin
    if (isset($u['class_active']) && (int)$u['class_active'] === 0) {
        json_response(["error" => "Classe désactivée. Contactez l'administrateur."], 403);
    }

    return $u;
}

function user_dto(array $u): array {
    return [
        "id" => (int)$u["id"],
        "email" => $u["email"],
        "phone" => $u["phone"] ?? null,
        "displayName" => $u["display_name"],
        "classId" => (int)$u["class_id"],
        "classe" => $u["class_name"],
        "points" => (int)$u["points"],
    ];
}
